#ifndef __TCountedPointerArray__
#define __TCountedPointerArray__

#include "TPointerCollection.hpp"
#include "TPointerDeleter.hpp"
using Exponent::Collections::TCountedObjectDeleter;

//	===========================================================================


namespace Exponent
{
	namespace Collections
	{
		/**
		 * @class TCountedPointerArray TCountedPointerArray.hpp
		 * @brief Template'd pointer array that will grow and shrink as necessary and holds counted objects
		 *
		 * Stores an internal array of pointer counted objects. Deletion is handled by the object deleter\n
		 * and is handled via reference counting..
		 *
		 * @see TPointerCollection
		 *
		 * @date 23/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: TCountedPointerArray.hpp,v 1.5 2007/02/08 21:06:44 paul Exp $
		 */
		template<class TypeName> class TCountedPointerArray : public TPointerCollection<TypeName>
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			static TCountedObjectDeleter<TypeName> TCOUNTEDPOINTER_ARRAY_DEFAULT_DELETER;			/**< The default handler for pointer deletion */

//	===========================================================================

			/**
			 * Construction
			 */
			TCountedPointerArray();

			/**
			 * Destruction
			 */
			~TCountedPointerArray();
		};

		/** @cond */

		EXPONENT_TEMPLATE_CLASS_IMPLEMENTATION_TEMPLATE_PARENT(TCountedPointerArray<TypeName>, TypeName, TPointerCollection<TypeName>, TypeName);

		template<class TypeName> TCountedObjectDeleter<TypeName> TCountedPointerArray<TypeName>::TCOUNTEDPOINTER_ARRAY_DEFAULT_DELETER;		

//	===========================================================================
		template<class TypeName> TCountedPointerArray<TypeName>::TCountedPointerArray() : Exponent::Collections::TPointerCollection<TypeName>(&TCOUNTEDPOINTER_ARRAY_DEFAULT_DELETER)
		{
			EXPONENT_CLASS_CONSTRUCTION(TCountedPointerArray<TypeName>);
		}

//	===========================================================================
		template<class TypeName> TCountedPointerArray<TypeName>::~TCountedPointerArray()
		{
			EXPONENT_CLASS_DESTRUCTION(TCountedPointerArray<TypeName>);
		}

		/** @endcond */
	}
}
#endif		// End of TCountedPointerArray.hpp